// FNERB.java
// Version 0.4 
// Last Updated: 10/16/2000

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.

package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import java.sql.*;
import java.math.*;
import oracle.jdbc.driver.*;

import Alkindi.BusinessDataTypes.*;
import Alkindi.BusinessServices.*;

public class FNERB{


    public Vector getFNERB(SystemUser user) 
	throws AlkExcept{
	
		Vector dl= new Vector();

		try{
			AlkConn ac = new AlkConn();
			Connection con = ac.getConnection();
			CallableStatement cs = con.prepareCall("{ call pkg_ALKINDI_RECOMMENDATION.sp_SEL_NMSER_CALCS(?,?,?)}");  
			cs.setLong (1, user.userID);
			cs.registerOutParameter(2, OracleTypes.CURSOR );
			cs.registerOutParameter(3, Types.INTEGER );	
			cs.executeQuery();
			ResultSet rs = ( (OracleCallableStatement)cs).getCursor(2); 
			int error = cs.getInt(3);
			int i =0;
			
			switch (error){

		    case  0:
				while (rs.next()){
					dl.add(new Integer(rs.getInt ("PRODUCT_CLUSTER_ID")));
					dl.add(new Integer(rs.getInt ("fi")));
					dl.add(new Double(rs.getDouble("ni")));
					dl.add(new Double(rs.getDouble("ei")));
					dl.add(new Double(rs.getDouble("ri")));
					dl.add(new Double(rs.getDouble("bi")));
					i++;
				}
			break;
		    
			case -1:
				throw new AlkExcept("Error in Retrieving Values",6012);
			
			}
			rs.close();
			cs.close();
			con.close();
			
		} //END try

		catch(SQLException sqlexcept){
			throw new AlkExcept("SQL Exception in NRE.NREV. Message: " 
			+ sqlexcept.getMessage(),6004);
		}

		return dl;
	}
}


